(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     57177,       1183]
NotebookOptionsPosition[     54994,       1137]
NotebookOutlinePosition[     55332,       1152]
CellTagsIndexPosition[     55289,       1149]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
This Notebook contains supplementary material related to the paper
Stanley Rabinowitz, \[OpenCurlyDoubleQuote]Relationships Between Six Circles \
Associated with a Triangle\[CloseCurlyDoubleQuote], 
submitted to the International Journal of Computer Discovered Mathematics, \
October 2019.
http://www.journal-1.eu/

This Notebook is Copyright \[Copyright] October 2019 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and is published with open access. This \
Notebook is distributed under the terms of the Creative Commons Attribution \
License which permits any use, distribution, and reproduction in any medium, \
provided the original author and the source are credited.
------------------------------------------------------------------------------\
\>", "Text",
 CellChangeTimes->{{3.77602941072921*^9, 3.776029415463889*^9}, {
  3.776029483519946*^9, 3.7760295042638693`*^9}, {3.776261082594401*^9, 
  3.776261180210319*^9}, {3.776261262802527*^9, 3.7762614216668177`*^9}, {
  3.7762614917472763`*^9, 3.776261550442977*^9}, {3.776261588698138*^9, 
  3.7762616175952168`*^9}, {3.7762617208677483`*^9, 3.776261729802679*^9}, {
  3.780343841826885*^9, 3.780343934037478*^9}, {3.780343965525668*^9, 
  3.780343972580963*^9}},ExpressionUUID->"ec84d7e9-954d-4d3f-9bf1-\
2adbad1f2e59"],

Cell["Proof of Theorem 1 ", "Text",
 CellChangeTimes->{{3.775838787015481*^9, 
  3.775838816170081*^9}},ExpressionUUID->"a44375db-8dd6-4fe5-877a-\
e7a40192c170"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"===", "===", "===", "===", "===", "===", " ", 
   RowBox[{
   "A", " ", "R", " ", "B", " ", "I", " ", "T", " ", "R", " ", "A", " ", "R", 
    " ", "Y", "  ", "P"}], " ", "===", "===", "===", "===", "==="}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.775649661605669*^9, 3.775649669293235*^9}, {
  3.7758387761226*^9, 
  3.7758387768982286`*^9}},ExpressionUUID->"da321093-4ee0-4a42-b9d8-\
1cfdcbd5d2cb"],

Cell[TextData[{
 "         ",
 Cell[GraphicsData["PDF", "\<\
9E14ARda;S<:9LCUl^G[Yo>Pd<C62S@P<21_HVX:?3`P;daUKVMdJ20e830PDR0_
AVU/M6Eb82m6K65dIDAUHfmTIB0n?PYcM79UHFd:N06=Ekebi3H<k_TD:9dR>P6R
B:V<WD^A:Qk_2b@kMkUah/;S8ZnO3bCh/m:^_>>aUPB9_hlP0;kC<kgCA?lAdnlT
m4YOWSjHWUiXC7l_CeSV=?aIOjIaYO<KbCc<937PndHL`R1amPjO8BiCX7oY1G:C
Y?>7BOXhEdU<?>8oZZC74k5?FncWm4IOCRMfC:O_m?3WCgAjYJnWI6Jf@kUGhZU`
BnK>?lH=TiFKUM]ML?MN5<?QRAWnAYjGi9[7=k]Ao6NB/10_k/1Zdg_EJ/2U[QYg
KkFk]5[f?_MFmaKR92HNiQEf`FkQ4=gFj0U8lC@F_MN`=Z_of^]UVPAhBbQ>mfKC
YMT9k<^Sj/gN6H[0bF6dGX6J`d[RDjcMRY1Z]K/B8C62OBi>7eQm0;KjS<0HHhS4
/am6?`N4NaOk>j`1mGPe[3M7O;h6]Ao1oGUH^hL3VmGS3UI<iQ7`lZ;O[KW/?LW8
iF`?@^>O_KgmfGI:G</7kE[]58NIhU9>ijINmo1j[;LkRV=?ei5FOhNOghkeGOZi
SNPM_X;Ci9W_l??k/Mk;:mmI/ELY@T^l`m>oScEf>W2R^e^`?M1ELhcLhNR?CmBf
S727eTE8I;k3fJ_GKD66@G;k?1mgRHeCXDA6Y:jLGMb4P3B<FUQS?mf7BP_3//1Z
i>UQF[0WiW[I5B:SW;5W7SRRdYEMSX<_/Z^LB[42YWbEiXL@DBVKX>UB7@ZfDIC=
C:YkZ]55C2EDGCoX4HDIWH8KNd20Co38>@GKVaNL7Wi]lJ2X:Zk^7CoJOOBh0ZU]
7VhT03FSXD0k`P^;9^^@T[E[LI/9M2Ih_4KAVVRKU6:RRia:/9bO^7B?heV6eD=E
Tb:i;SAEAP1C/jM/ZUhT<JjiD3EEB0505f=<<dhBmLO2M@>YdiH9/6WClm/Nd]Yi
mI3:=5ed3U[J</Ta[`<:o`B2374D=2hbY_JRmA^5L0IY7?`jhL@;C@@e?CDUFHi[
10@A@Pd7dDQaH4KJJV8HoJA^JPWF2:X[6`@CjjKRAYEC25GGCE1U@VeLJgNc@CDe
XXKZe`kE@NJS?:09RAD1BYlb@J>6jh`>426JAZAXHjJmM1[R5/Xdb8Y;Kd_XkEc7
QfVFZC_C9>[fALo769<dj`1D/>hdMK[Tc;36EndlddfH6;fj;5O_ljJanJF32LSM
c9<I7W]0f6A9Z20Y6DjBVYIL4M9@Smol]KF<@FHT@d@O9MRYd4U4;U@h6elDaC0o
GgB8WEEOGT^0E<HlPdagQ<n8L;ia=O/PNSAdg7?2iRHjGY:E<4;OEfDFL]Ahg38=
91R>YhX[_H4nFlih_^1J98me4E<EX@nea56VB]BmNE4bAf45J]X/5[Tja]jV=2fJ
PHFe/kN3JE/E?>h=d_?e5=KSm=A7TCi=mCWHIL<nSFU:;Pf^=X5iaT<H?Jk5G0I;
XV/ck3R=LC4l/]>:FYd9k1DaE11S]FWfgaIShC1Fa`UVjiKB67:[DU]<ZR][Inl1
EW04;MDmH?gA`7[n7hca<2T:IFiTLgAbIF5]2VE^I6mRJPXe830PKf9Z2S4a<cT:
IFiTKf9Z2S8P<21_HVX:?3`P;eAiL6DP;e1QIfDP;e1QLVE^M20c830PDR0_DVEc
KgEbHfEc83HP<21B82m3KfidIFidLb0d830PDR0_CFETJF52KgPPFc0P<20d=3DP
<c0iG@Xn?PYUKVA_HVX:=R0`86mRJPXl?20_D79_He=UM21K82m@A4HP;eAUN7@P
GB0_@fm/Kg9CL65SIB0l?20_@g<a83LP<21B83hn82m6Kfid83`l82mDE34P>20`
858:?ShP?Sh:IFiTKf9Z2STP<21_HVX:?3`P;daUKVMdJ20a<20`858P;dhP<b0_
@FadIG9^HGAU82m4IGIYHfEBAd8P;dIYK7AULR0_AVaQM6E4IF=_I6DP?Sh:LgAb
IF5]2WP1WIIgE5?I5XO?_CNmd18R82Gd6WX98=8kB1D4DHU9P502QX@VMT@5AQ@A
:EITE<01AhLRHdDD2h>2H]L9lQ1@a/5AA4GUgHa[2Nn]=O?NV_g7FMoIikOGfFO_
OMNj053lPPC2M5P1P3BQF1C^jl5L4Q?;a?L261013UP1`>5VIPA7n4@2e?bm?IVI
Z4S6/oK^;X1T^m//_e0VLmKoOi4R=d<T1P0:AMDf?7hV5nD2U5>caATbo`C:m9DY
<XHa<QJQ2J:/8^?4[fcfYnH[^lVHUbKTXAYIcQVl=9j<^e3NVRGQXh`4XEbH9N1W
Xg`7IKeDBIX0iOLXdm?hW4`0<1BIGlcW9Z5/RC9551W^RO8200RDa3VlLPj;nCUX
WP1hYVOTRPB9BF:V4MNHJNGXb6KjlK=CnF8a:iC3CN68N4c?m;@<SS0GP:m_UTD1
9EU]VFRAkJdLkNeIe^IXnKoIgainDodmb7[kEO4Vk<nN@HbNFMm/k:`__AH0mRAJ
Vafc_YEE0;A]1T3UhJa?kb00lPD0]=jLlaj6K5jBa>8<9`^;k>a/L`6OJbh[j3Ok
Wh9_b[n6>ONIbnkkES^V5cn18dTE<fE5iJJWYT]4c<`<3YO?I?gg4?oS`3UYcLW3
;9bO`1OaQNQEDNRD2HB9J;^5?85HT2iT2XAoeN5o63HW1aUnWF/DJ7EO07f5>E2h
B@O8Kcd0@b<396hoNP9mje/@<@[8_[aX[I6_LhlbN_kWnQl;G8Y^hDa18U?VmPb?
I78UXR`IXmn4K<424Y07M:0:=84^<08/H0dLP3=`0mhP08B0B103UP<^B09Y@0Bb
@CkH00Y1<MP1MX=ZL03DPG[@14j2=W06G0AG`0e`2`b0Ad0:Q/5;<07NPFT8P_0@
5J91ZY0FY0nI@]H@6eX8ND=1D3PD0lE3RI0@TT3id2JX62Z3ZZ53D3gd8g@J^PQM
PoZP1m0P=0Km0Gf44IP2df4=f02fP=V`>a`8Al;;h4Ah5I`75l3KhDZh5Sh>]l8G
hA_`02b5Gl:C243820?AAUP86o54@Y1H904A8F^A8Z@2ZDFJT0jT6kV=B95ai0<6
Qj5QV1PFaQWSQeV<hF9FHMIRBS3EV6>HET`GiSIV43>1nH:UH]FaYUPW[3mf2CHA
Vhd]a5IPSf1K/9Na0mQQk3/L3/O06N8LL7jh65`bKSF^1;L?ehbkP>_33N4VlGRl
:]hDkh8?`G?`HW`Q_PYo77lNghlOa[lWT0UJ16^23b6F82A/95@@6PSW2?f44L8d
DH6XCg@RQQ1ia5aR:K6>f46lBA`VCY<DBHHT5e8T:IVdPEA9JR9M9SdV_B6CbCYT
Ag8HFD1NCjhTWb1O9@nB?e2D:2HDCdXLAD;ICSU:^D1i@7U3YE8=Z6kDF:ZH^YeJ
Cke4ODYm;dNC<iOcUn?9[I>[TF^EjiMk9DnDeiMgUel^WbMO8Gm:oZKl^09A`D31
Dh6S/5JQA^6d`Sf5BDFJXYERR6:JHXURPn8eaE4U_9:1T[LBCjU0jK3B9JDQ6T;C
YGWB^;A=]3[JIMX`7DLgY?_CTnW5m1oX_O@9IBEUFnDXiAcU6^FcbU86`S1Pn3=B
6JF<ThbkS8oc=>Jicn??fcJ_JEko_2VEnBY^:WbE8YEVU@6ESjY<EFoE5=FMZVfZ
Cm@`JRIZHF[IJ__E;Z^=cjO?Mik?WEldonClQnZ`^XUj^?YZmL?Z?NZC6YXJ_QXI
6UDJUcC6=AVJKY[9V^FJicC7]6QJ2kD4F^EJikEN<9FIk/aDIRFcRcVQ[Jk]YbgA
?ZCMZcf]HjRcF6NSC[?>4efB;U/g@KML]e=g@Tm;;eP_GjmAkj4nDIn]WjBoAkmK
Ol[0d23JH8]1Vl6XXHZQ_f6NHJ?QHb>ZTJ_A:Z=JXc_6>6>fLH[a?^=K9[29WDVB
BHg9CE?He=iDH;[?]<l<JnIX9SB[=K_7X[3LFEV/A]JP>L<lb7bSNI_i:`/mReR;
WAKM5Ul/kBaC;N//7eTYF@EHKKCZ/?[3f/BJJeeSOLN6J^=S/ljVgNJe[JT]ggJo
kGdkVUf`gAJkC[_?mPkf8_/Vnc47?HMhQkd>mmQdMRRkQ7gE4N_XhKS>lHcS1bMk
9k7CBJOOWEW>:Lh=cZ<;31O`5m@]67;ALN6h77:A;V@^S5mhL:7DEM^Ehe[[n/a=
ehgWM/A]a=gH?MWm^?/[3d/?TDN;aiBWTnLJc`]NR9N_Ei5G[kNBmf;_J^nW?SXn
RCj=?Q>nM[j[OBohHOd2oGKjgO?Gl>Ojeo]?13P4[0WX2Z@4APAF1ch;<PTB1GD4
`l41`K^27boBGbALe1H2@_a3MXDl2CD<GAGjLaP^;3B/9^ai^5EhOWQg12eRADA3
a;]8SlSBb4N;SAI;5WM6bDO5AME7CDEkAIM5BiMH;5Vci4J<FX`PYSdF7a/ENbAf
LZWgd]e;Qn?/hP[SkRhcG9Jck=Yb]NFYbln^T5o1FG4Z7Q/O7Ml@ohTC`ZWUC:kd
GkUgi@CGTk^7ni;WaR_WSO5Mn6GlT@BGQ;:4dDBGa5f9HdV^BAE9h`9?@KGPMK9O
lX7TZIB@U:<Y<jWAZLeYQ;Ch]==29F6:/2]M<cdW_Bo3=:<`@k[:JMG^EA>R@=6A
C2QcFFJkV8knC?E8S2BK9H=I2k=Z/]iWAfFObU7<4NKdi9[TK//MbO?9ngheISEg
MFNnM_j6o<4ekV/>[HGF[UcK^DigGL6jhOFnjhm]86e8fO3;A/^=IA_OKX[Ne56P
DK2nH6RcknK6@[U2DN6m;LiK3Vc5K1E/kMeV/jeZfiLRG]7eH/_RR^9?9MbBjmmI
OEOigLcfQ>fmYOJUngOPMPQgg=gY^_=HVF9IG]W@[^1M[NG<lZ;b]k]Gk;iFHE]a
H0mYSfB?]3:X/[e:[fY7eJOZY>Z16XnJi[gZNkO]WM[7fmNogfeod`6=0lD7?QhD
7;aob?M@Jje1KLEQg>6/`lo[X^Zj_fMoGgm4kDSaTLm7QDNUal:?MMDke=LgZ3ND
=/:=T/Jahg77KogPmD=k4j_YD3>S^OP4>24ilN;7n1o_WP`lfGV:OJ[Y9ofOm[K@
FXYJXMKLeXVfY3IYNdakgnV0didMcQd]?i_oO?B<mYVJ/lYWBlnAcQFLVcVOMgkb
@/J5lH^95hLjEg@n^[CTdYf^/:kNbh6G[eka^G:Yfkgko5FGZfN^>EdkOIem_Nf6
oHgF7[^NUUo/OVWY]Nm]_NU`/ofFhjf>_PEmioYMnboNm[YmiHkoWA/3R`KjkRjn
NomNg3gYOMkmd@NY3ehoc7XhoFSmHncSXRL:CbZNZSn]oMGhefJY_OC/X=MPck>8
Ihn6^4<_oiGi[do31LnYcb]6]4KZAje7chciS=ej/OC5l<^<Um?SQKlYo[KgUM6[
WgignkeWH/W4l6_AjiToB]jX_SWje_I]ifCXi==gJNnVYh[NZkhomX7mXO]Sm<NA
jNa?n4nEWhdoMg`9o?9h9VeVi]ogQ??k2VE^I7=dLVEQK@YUKVA_HVX:<C0P<21_
HVX:<SHa<PYUKVA_HVX:=b0`86mRJPYK82m9@d=2HG=UI20i830PDR1M2VE^I6mR
JPXc830PKf9Z2S`l82mDNG1U82m@HFMULb0_CFETJF52KgPPFc0P<20d=3DP<c0i
GB0_@fmeKW@P<B0_BfUTLb1K838P<21B85dP?Sh:IFiTKf9Z2S4a830PKf9Z2S`l
82mDNG1U82m3HGAQK6mW82m@HFMULb0c830PDR0n?PYUKVA_HVX:>20`86mRJPXl
?20_E7U`IB0_AVm^M20_DgERM7U`IB0_E79eIEAiL6DP;d9QLfE6Kfid82mDD5Q5
CDD[B6E/MVEdJF=Q82m6KfidA6EcHg9YL7A_LPXa<R0`858P;dE^HfmTJFiW82m=
HF=BKfeQKTE^HfmTJFiW82m6JG9cM4=XHG8P=3TP;daQLgA3J65b834`=b0_EfUT
M6Qc85/P=CDf2SDe=R0`830P<20`830P<20`830P<20`830P<20`830P=SHg83Hf
=b0g<S8P=c8b83Hf=b0f<C4P<20`830P<20`830P<20`830:=SHg830P<20`830P
<20`830P<20`830P<20`830P<20`830P=CDf83De=R0e<30P<20e=CHP<SLh83De
=R0e=CHP<20b<S8P=C0`2UdP?Sh:IFiTKf9Z2S4b830PKf9Z2S`l82mDNG1U82m6
KfidA6EcHg9YL7A_LR0_AVm^M4iQKFDP;eA@F4E=AB]8IFafIGAYHf4P;dI/HFMc
83<b82m6Kfid@T9_N21K;CTe<B0]=3Pa834d=3DP<C4b<Ud:;dUdHFaYHd5^IfaU
830P;d5cHfE^M20g=c0P;dAULf=UKW@P;C8c<20_@f5`B6EYIfQd83La=b0_DgAU
KEHP>CPP;eQ8IFUWJ7@:=C8c82mCM6E]B20h=B0_@GIWEfUTM6PP=3@a82m=HGQG
JFAdJ20a=C0`82m6KfidAVU/IC8P<C<P<21B83hn2VE^I6mRJPXa<b0`86mRJPXl
?20_C6E^IgAX834d830PDR0_C6E^IgAX<B0i=c0h82m6JFadIG8P;dI/HGAUA6ES
KfAU83hn2W=dLVEQK@Yh0KeJNgcDaKDolg__8i_McFkfTGgVUmg=>b@Q8B61;249
hI4H268FRBB1@0PPTDLD:S@PR0BT8PD/]2YENHYI@/@=51]Y;?Zi?]0ZERje]J;e
NY^?mUkaZY3MNgjo3BVTjXLoo7AoWc<cIfIn<fNnLnK<VOW]b^F[VR46>X26V]V=
K@]0oRD]0B0MliHf]TGi>2WJ?ZmmYB_:/lT0m985K@^GAWWQi`1:nl8UZhONS`/1
J2]KVQ_WAl_Q6/Ki;IPAiLUXS9=JUZjl;l[[Nc2N]VCI_:7b^4N@CekJN=m@og09
NMOMSD^KXoFC:S5>JU^fH^D@;dFEKL^KQnZC>YC_CB2H6`N?PP8F0`lDJ?6Y1n0o
EMZ1`E:Y77oEWKmiO6i/lAG@2C8o]nYWL_cNbhLfO=elcJOJ8Gb36H[[mJFHB`VW
0:P9UPnXMPbGb>mQP03DYXEP<U89DQiBF]X4<gB@0o08dY=8=2`RFf4edQJTGb0a
`jW3b?FB[Mf<h3m5EX>EC?6[6>M<PlEYEZZLKhL8eo>hlggcAjN91FO_@f;YSP75
12EiTS`1ll59WP4?F@>ET4cfWTQIhVc0X/?@Q]B1A</Q8HNk7CW>5dTjN1R2kgS1
`I2Cc[mUIcPocPiAY=]ieQMR<7[9PI`oe]UWOmciFo]2ih]8Aj=5Ae:`aTWWHO/B
idi7R>c]MSiZ3a5lIdLdFVG7EdljUjK/M/k?U/^Wk@iAAk^MQEPnbjmbiQNhWGWf
blh/GdPPb6OHYcUC/emg9^6;F<f5SG[l>ZO=_]<i5X/LmW;OF:CCi0SI1jUTGkMW
R_<D9W6h9bJW5>`>TInLZ4c>mXC86WmnIO;^U4ZO9fFJdi=BhO=QN]H[o4KnCWh2
Wl>WlLVlUgOc2Ka1d0]J@B>X1JDP27b8?=]Mh^A>Tj=@P[0L?B5`0Q/Rcf4VLiXL
Tc>?_B0`0RF0H0Q5oX;:Bl0@8TMk]58:4bLi>LF5b;4CdJaSORLSYARi@4]9J@``
18X854b187Tha<6Vn?HBLhUn_:j`X^ckPPJii7ZHm_do<k47Mdn][@/N/@N2>E8R
HPmL[fjnW_SNN>DZ;6X^CD^K>V?eROJfePGUcF9iPeSNS=@@g=[NHPif=;ULae_K
Y09GT?Hf=<e[TN;6iV2Kf5`FK1G;G<OKiOM652n@R]_5/^>`X7aVgO45o^JbkWIo
NkWHF1HhdEBj_?jV_[H<mkFlm3_j:YDJFbkeeBBo=j:_NZVhBNZ[G^Z[G^Z[bMlT
mbD=_WaAKNV:UJRM[_95Deg1i=[Pi>Vcjh:^aT1IR1c0c;9E`?J1USd3bF`7F9T/
L094gTNj:<GQfb>O/>M06ehJn@MMQ9?J:a4E;RV6?WPHmT4GL708dlU`5c`6[i9F
G=]cX0L^40MTX^eU80CCh3DBRK`52n1Y[;lBc/8^>0iZO6LY6;5d>o54eR3_ag@C
K8cl6Y:P01j4<e28[Fj7PLSQb0T/W@6g`a4hR^oo1a6YhdaLi;W8IA1P>[Ji4D_N
RTb;M84NdZ4DJS1g8ka8??C5B0^HX@RUnbDl0O_Q9OPkfD1j8RfAm/Sib8NXZVJ`
@BdnJdT?nI3^HQj<o3;bFBB<B2A3:_KJ03_Q:Fbo2iln=:gUI35IBGJBGIBOfT3e
<9]HDgP@LDR1BOQD`S9h217XQGkh7oR6O4jIJBfmTWhiTQOiGe31E1bU=99VJ<MW
<ckKLDbW2DM6THVTQZ`U?bNkb1nXE>YfZXjjUkZ?nXB^Y^O@ZnTo<2^HKWHKnaRW
2Un9W8jLRk`;9[33WK0Le^7Xc/9in1:n9CBfIB<NDTA:bEghM91mE2oICgZY6]97
cU=7b9o9AnAcLYER:CEUY=:XUMA>jRQeUWZ3GTC_XWm1oiVn`XaW:GHonc7WhOlc
g1CN4WhSDQCi<?8eVUP1g3PcYE0=Lj4AAm/6Xn6W>8YSn7CQ[?G3bo2Zo7a4K300
Gb<:@?C4BW985CkEi3JbP2`RSi=Cn;`Xbo8EQA=1:BPMIJ9/E2gEA2fU>ZQgZ@hj
PDjUYm2cjBilGZ4_d5OYZ`c;a356IQ8c6KHaBiVmn1aP3S7Mc9]/8C^N[FIW/Ag/
5WHK?HmmRkg0[N>fLmgLim`GJ1JWlL_hKCPk[j;>_XBjo<lO@i9@nQbh6nJA<]84
^g4fmY=6j4C]VTlN@[cJ83UBCjnS9e6SD1]NQ9nP]^j5]K25WP?k8gnTSl1kZ2WX
Gj3N7fA:`Lk^`MWI0:=@RhHNOdYZB[;?jdTB4md^=?Vf1:_5K8Xg6^;d>Vf<FZED
23c7<SA58;eL[6Q`1Kd=@LH[EUIVB;cHR1V==f@dh59f1B]^[Q=dBNleH]5==OeH
Ll68V_iXCOm`CJ9e5D=aA[Z[G7@5GblCGB4bNgXMYQl^4`>^h82L[Y;CSlSY64bk
gOR2ZmcLD^H:TPIGNK2R_JFc_:4/8igdnQ4>IDJjI3SlX98J3/;4a[EXH66RE:<l
J1G;bX<F4M=HAW_:6nL7JjKGUILU^=d1c<>/6GGHAdKjXR3:2E_EllGiFd=nJ6Z@
DXecjX9dHb18=DQ]jM:29[4/J5[c/OVOk?EDnKHK2X>DYj:a^K<Rj6oHR^1:K8?4
=Fi3KVZ]2i^U=PGZPVCCT12BS:dXZBA^M4o`=;BjPPZaE6cYK6e0L656GKOEKiF=
Ka1Zj[X]OX_<I:CgV]LE^G7d_ATC<RI8LI7K_2hJonf1J?kKOE9/G]Oo5hbWcQP6
P4P8R9=AcZ1[W]b9R<8FB45c0GC>:d2Ll1LP><a5:<o488Dj@g^2[6MbHk2Sm[XH
;FEAhAYJbkXE5Z^l2ID6/7i3YgH/cQCFehZ^cR^hFcN80gno>JMa:8OcJ:n0E2Q=
m;2^14WSmGBk]5UjL=@]I[55V]mfNDjA5lgU=f@P;d4SbA`dh0INDnL>^P:HPMiT
n]@@:6[ZSQ>b?A0RTDdQ:;?gXXm:ckd;Rm<UEE]DQ_dSTi6>6JU^C6FV^bZ`i`Y9
EebM[/k9lc]M5JhFE2K68lMHd=`Ib484Jn/@9iR9?OX32L?9iT1P;;JC9KF3[f3e
cP2fd3[D0/IbE]HPEQZESY/YkJfYVehGk2Q;2?[;0SP;Z;im=GG1?]CL@01[I@m;
RQ:_GF@NTST7ILi>aO;LJ2_X^gAP4h7>CZW=fS[A7Nc[k4cXU=IKU0lA69WQ7lX8
PEA5PSa4>V[`GHa4Mh8l1fkASF8594a7XdYOebSdfGlHhOaQ^O7=<BQ]_Xa``Hn4
L>6]83cfUQ0^6YKd9XB;DNHR2N5aocj4amn4L<T?8n`OUQ^5W83BnVF4BglTQ2ON
2/9U]hA`nK2T=b5LPC:GB`Q?n_LQG7TC`Y=o6>4Y`g:ST5=AfRTb`]=n98B[KPGQ
jU]2n;IQBFm2^0IU_Te2N?Zo3n4I=b5Lnl<8cabF6hFl7JFM:B<ljdM2n8iK@KS^
UQ0>34]j4l:cDNJ0Q?2M``Sk4h9`Xag^665fhDLgc7=^P1`m9EH?YL`:j4Ob/k?0
PK@7cencTIk1M1Oc4GC9l@ZHPGGJlN1MQ74UE@PfS<LQKBCW8QLa_`>K^gh?Y<KC
RLAWhcTXNSQ7iW]n=9kIF:c?Xioo[co5_fJ=b57R6DN=NC6PPERlU@;@hIT/n/^7
>O0YWYfnYQjR?Z<cj@Kj9=?1O<H^hO:i3G`Z_hK_4I;`850:`9c7<bV=DTb<gSL9
FB5PT0@]G/2MAi9hC=>G<8daSc6=/N8BW<:g06JUWL:FF8a7INOZg3XODRVc?GC]
[nbIKbN6V:Z[N7n1J?CS=LFkk:<hF_6h@48TejmV65k=l;]ID4iBJ=_kcOg_3QI2
BLVG[fN?R//KClKTjTAMonofN[OgdEmeaPD>O7/goIGLUQoUM[2oPT@hh:o>IbZH
>mS5m[/MJa`KbFI:B1EVFaIKk[OLKg_N`T8RRFE/6X^K]eW`SXYea/HVaRWchURG
LiDkDNgn:El@_baAhh]Mkba8C9XTBW:l<o3UP?K:`6DX:Ah/;QW@j@^cm:I2P[6n
/5270MAWSiZhfVmS;6Z?cZ_BJi91HN2CRHF9dBZCRF3406o[]5XRG@j/QoYlO@W9
7i>O=mX[9_8L;f;JWJ<g6WP^UW2HhCJjYfajZFomj1VkeoI>lS8_d:F[B?9G7jf^
N7i;Dl5l:jfiU]9;m6g;Y^KE;UjkLm_DCJOKchNoN^[I=I>JYnEWgm5j176Q`H6J
?@kWT`99>bkjJbY97FTQm4?d7^HaiF5UB15BL/U:0Sc74DY@:31@0/nBKHAVG0JU
dZ?7?0?;N_AH@JERJHFBhERRXPP=U8<G@RCPEn2aRE<XJAJi@gimC8c9I6DO9hl[
;NZHoNi]Mn6]T:GjBg?Eh:2U^[bik9>:<S>DV8Y;RZ/64DiMHHT4I1C9[<fIJF^e
Dm6kHoXBPTaoH7>VNBR3aPbj?i0fE7Nc][RHAlXNAN[[XIjXB5`^4FTg;A9jnil7
=We86Bo^6Scma6_D8mA/J/_P_OBlKbNBD;QBe^hmR0^3:BGNPbC31Wo1k9SI^UJZ
=JIE]hJjele?SZWDDGK16L/hha13Wn0`DBZ7Cf2b4aK5IX_FE8GATaa_BDT=TKTW
g>d;L8SEGd[SZMInEHG:0RF39@>X9H>bT/RjXCMKFL7RhKblVDTS[5E8@hf@e67m
NQ`1bI6D`NLEgKXKT[CK9IeADAoRXg4:XO[GEMbmZWA3n5OTf0_EfCnK]SJljWOD
_HAJj[l]YNZNPWV1CN4?1WOB=N:HWcfBH`/G3/i^WCSgbK7>`J]/g=hkkmdJb?:U
iCLLg[kRFMB:fI6;k3g/af17CCW^;dYPmi3M;>dTCVH3fLa^RF=[1OY1^diWi<KJ
JOEHXl91>A`F>Y/ZdVK[[2i5]/GRM>eg]dH1Z1XH6Sj>79O]P0b1MT0NoUR`VCaa
GXdW`J^:EnA0S46K@oBjF2e_@hh5>XL@RZ6EIWD>a>Xa4:aL3V481]:B8MYRKC4^
83VD<]KGTgZ1V<A<8RJ2CZ_?A@37i>;BLK]lGYdFUi?8><QXgEWgbmg_Qjolho=;
:lHicUXOk@Zo5h7W?Wkf59VDc7hL_WQjnh7`Vn6G`n7`K`l7MWcjZc?kGRO?T_;c
OlGe@l4cZ2OcD4mRl:iZXMniFKMKCnD8:TL/1@jC86C7FJda7Xg5H[gPK]lR:d7E
X8b1Y023l/2m95kW<GXiW^DIW^HYW^FDFP576hn1@Zo:8K`1Kcm`R6UYZM:h?=98
9=^PYE0KI1G@6GP:YoillhBEDhZ//Noo8oc4:e@]bCZhZfiOn<71[R=6gk;0e]Y9
A4Lb[ck6a[eg=_cFIfO2gO8H^]0f3^0HY=fQfYo4>aQ6AC]`=e883ZE:D5=Z=@GL
8ZY8HMG@PPL/<IX@DIe`kkXn85VY_k`/FCfLELT25/^jSDHIcIA^R4PGTgE]9ief
kEgjoZ]W:BMkYRMLNRB/jL:^lDO`SPNH8lPXX=1_UZA@34W1;BIFUMbcDQDRMf3?
UhJPU7]6Zo^_7HYMm=E[[e5_3FJMTc_Z6Y`_cIODamOHQa8<d>S?FjANY5n]GZ=W
:PeeQQK36P?32`jMEZ/TVUP90JE0LGXeXc0H/QU[O:`21fn<ohk13n[@g4O7[TDD
40:21[lncYf3Zi?3FA91G[[^W?bl;VYGoaLG?PSWW:<kkR]M4Ei9]SehT3gcYeNN
S@c^I7[7>/?dlTLTfc`SLTVnBH]5gj0Ho^@_B1e5U5YEP][VbjgD;U:dJ_U2@JmF
d0TiO9;2[UGKRm:Xc9BR5hZXXYaDSek;/h;=UfRbQDRWGcCIWKc?WZVRk7VZH[jh
f6KPDe8?9EW79jCHY/Cj2RcSa_n6k<4;a5jb6j;`XYfBM?GbH?o`NRdI`9VE1U^?
/idiT3TPVFJMZE3Fi>Cl<LI481H?bHmePmVAh8IhUl5=g8T`QW:3eFib4j<K0eAV
JL7:bg@mKWJT?RUNFYoSR8K8fi_aY[e_?<W=@O>V<f0Uk4:3:m[WmDVA=fmdoYPh
XUUN?CN`fmfB/k@Y^iKdS3NZ7eScL95KNHSm_jO>]:lbNM@>GFZj]cheGS7VSO]g
WCVeYo?=fNVC3n``fSQ=S2e[8ETRY9/ci]A>BjgmoKk:b/L6mmPBJGZCVR/EoIF]
ccndjnThLUWBWoK81hb7?H^NT`?Jo9T7n8>fmfadXQ3[X5P0TigUMDZ7GJDbn0B[
biZYcB@YX4<C^=UmY_kj7W3ilY05691<X0km0aTm/cjNDlIc1RoA:c4`lRH_RE<h
_=6E;l4DUj^CX=3[39B<P55<RSX8W=5PR/m]kbYj^^6EKkjj^6IVC^41J/6>7@oo
Y=LkjBakM_2oZjJ71l9OQ/?18[5ZbmY?Gccl`LVgm]aeG5koN7]<WfNZ`@X9L=2O
MM127S<O4XjHjBV2KYn1YPfLgL[7f0fZ13hQ`JCej@W]XgAF^m9W/]S`TaYo`[el
kI36h<R:Z`H:2jGe?m;2S`J;h54KUEk@a6UaU99]]b27]]d]fgIEO8`GKC/62S?W
UFbknc]/^j`_41nek3`>GMJ:G4TMZ3`]i?;DQHm<GM[UjijM<^ZQAm/N/7@i_SSm
m[M4ohj=Z@jn=nn1@d^Og7mYbkg__Tab?l6[kk7H?eBRIfk5Ff/KO^7`4;EomAkQ
5mJ3CY[ED;6/`JSAaaX=O[GO8:AHbECEBOXLnCem;^6?`_^:2lhoRYnJ?QEEigCW
m=@LPGDWaNj=]bLELS`OkkKKN:DmG^GQmmP>fUi0GF4llK4N6f]AZWTMnY1f7f_e
9FGb?X_5jg_7OB2Z95F3DAEiIe3fNVCW9j]n64ld;e[9aiCEYP94QZGaT`1Q6Lj9
>i]N6jLeJ1U>kDU<B?:22naNh[0[C;`GE4J=UlAXA:/K/eP<13?RSajX5j@U6EfC
l[Y<CD]MCnjYQg_@Md;G0UNOfh6Z9ffQ6X;^1RM_ZY1;_6SG4SVND3dG2_;efV^O
/ho/NGSV:<=ao[K/6J/Wc7PUo1TaoiDhELUCS]eoR2DR<fWakM>GC?WeDboGidlZ
fY5IHm<B4Kn;D:@dk5eE/N549i4n_>=nH<<5If;OaRlYEOhdg/hYkCB9=AC6ag1j
Y@EMB4f<;/FTioFa6ZN6dU`cF<bFJnj5jhJfQ_[2O/T>JfF?DS;=j7bE3;b3cXIn
C7i^C[c9:7T6W37G:>:Q@Lc;cG]N;>WA9IU/5]D<EgM?mjiMK>WX>ACe=4E^Ofkk
]OWd;kLO@[UX61L^XSm5GG521Wi9Nl5OUFnH;4aFe0T1aD?Z``V7k8Mm1m9j4eAn
PHi?C=7d:a?Am39LR]fRe=^E/IUlIRI[Xc?S<c=BF>/X]LHG<mk[/eVbAVef;blM
][b5TY4H_7aUJ5M5G`V]QCc]dGU?5i>]3YD^bJ?eRPj_5i:]6>QD6SO4J]@a7W^R
UoPBDW0mZOE^NGJ7?2BLi_FB<@6LeKaLM1`hMj;GUh]C;4f_K5FCM;R<@3ihb:/;
G@e2gGmGK]j1h[K`ZlOn[WTQaSO^PCOmGS[o/KG?QJlBoQ@YNoZW;eIhM]iom[Kd
l5]<jGQah^I[>JneGmcgC:F_n=5IOiYAlgo4CV98IWQoGoOL_LnOjIZgTLZ@igTS
PSZ0=SDNJ_gY^6X44flBO8`_KQFoBQ3RHZPh8aiEkAa_E2]SDYAF<c6V@;c5I<Io
99a`=dDQ6oJ]l@PVFmE28Rd@fFRR[aCM@4BMi47SY>_4SCgng3/fo5M]AZlSNg?K
bAhdTYNV^`^O2S`n>9ejZWe<gMh;Pjm8NTQ5;XI[B07j33AJOCcKe^;aEE;?FOSo
2R:MKlm7ckV:loQ5EH<EM5VW/:idcQfECE2ab7RBYi>AaPg;A`YjN/:oGYgMhbd9
a]RMc<3iKdHchQcVi=DaZlHfDM:;f7P7HR;i:BZdb?<351T[40^52lo4gL4^I5Mc
mo6KfEkjEOXR[FAI3_m0X:2YSMC?DEUYZQ2?I0b;7j^hYGY4Dn3a/aG;:@AFLYoA
oj4i9LlY>F^<PU:VP0X?HMg^YUhB7mge9B2;;MGJCo0<EXbNG8Vdfa>TcEFIJL9J
kD^<M>BZImMZnkA2/B2O[m1<;<O=RN@ZL2Wc>[7S67WSTo02L_bCL?NNHnbIJdO9
^O2b`BK:eQVn6lM7BH?4[mS=n:ge^gkBGgl<N?92F`aNl>49;0DE/Pc:X@:ohTk6
?bi<QB[lbRTQYDNBOYadXc6cYZjlZSb]/WU9No?:AO<JiAYb<@HcTAZ@fY0jT=39
PRNAPTQmB>NAoX;dQM@/TQK9QC@:bHmDPmB0e1HInP7nQ]<4kg1^iW=6l1=6l:DS
n8TSn;8AO?T8_V84So;M98ldnQ_UJa[1ca_1bg=a`gPFS2QO>89_6L6gS^0GBoco
0jf;mI/:IFiTLgAbIF5]2VE^I6mRJPXa=20`86mRJPXf<SLi2VE^I6mRJPXa=B0`
86mRJPXXKF5SCe<PEVEbLfU_KR0a<2ha=2hf85`X@WEYK6@P<CQ7>3ML:B1AMF5b
M7XPD4A6@fm^M6EhM2T:IFiTKf9Z2S4f830PKf9Z2RQ4>S8`<CT`>38d<CDc<c8f
FS0`9c0`9bT:IFiTKf9Z2S4P<21_HVX:?3`P;e1bKfAeHfEb834e830PDR0_@g9U
HGAYKfi4HGAU834f830PDR0_CFmTA65dIB0a=R0`858P?Sh:IFiTKf9Z2WQbIFH:
<20a=`X`<30`<30`<30`83He=C<e86HP2S0`<30`<C4d=30P<30`<30PKR0:<30`
<30`<C8e=B0`<30`<21^80X`<30`<30d<S8f830`<30`86hP2S0`<30`<30`<S8P
<30`<30PKR0:<30`<30`<C8c=B0`<30`<21^80X`<30`<30a<cDi830`<30`86hP
2S0`<30`<3@a>C4P<30`<30PKR0:<30`<30`=3<e>B0`<30`<21^80X`<30`<30a
=3Df830`<30`86hP2S0`<30`<3@a=c0P<30`<30PKR0:<30`<30`=3<`>B0`<30`
<21^80X`<30`<30d=SPd830`<30`86hP2S0`<30`<3@i<c@P<30`<30PKR0:<30`
<30a<C<`<b0`<30`<21^80X`<30`<34a<c8d830`<30`86hP2S0`<30`<C4c>CPP
<30`<30PKR0:M79QJFaULPXl?20_DfUjIB0a=b0_DVm_M20a<B0`858P;dU^IVlP
<B0`858P;dU485/P?34eHS<c>C0f=cMT=fDbI6@a<SERHCAR>CH`=C5Q=V@b?PXl
<CER<c<i<3Hg=f@gIC9TI34b=F9Q=68i=S0e<F4fI38n85dP?Sh:LgAQLWAhLVEV
2S4a=C4e2RDUADm62P\>"], "Graphics",
  ImageSize->{289.19140625, 200.80931355337077`},
  ImageMargins->0,ExpressionUUID->"125f501b-c64c-4642-bf93-eb6c4c582de3"],
 "    ",
 Cell[GraphicsData["PDF", "\<\
9E14ARda;S<:9LCUl^G[Yo>Pd<C62S@P<21_HVX:?3`P;daUKVMdJ20e830PDR0_
AVU/M6Eb82m6K65dIDAUHfmTIB0n?PYcM79UHFd:N06MFK^>I3D@cOdE3YL0ho;c
>V@G24P0kO`0]8@@HP:d0Ko?:M]EMWOOkQW@BZ_[djj7bnEjcMof5o^g9O^S3OI?
nlfW;f@oOKHNolQno]Aoh/GGQ?mR87]i]JfjU4Z:=U1f[LAV5fI2>5a^<MZS^^2?
D6b8Qc/RIE^CboDh`T8^]Y1[ZLESHIUL9L:VbLPX8=8^ER4OGH`Y;cKDX_?@J@UC
i69D9LGFDHCC@YJh?ncWJJGM50JVX40^=1b9BW>A:Y]RHDMbPD:ci9/;8BI;[KQ`
e69KLS4LVA@a5e^KBc7VXYP]eLEl7=6BL5Z8b8<9MEM>;XEX5Z<DG4bPGn84^Fa:
2KHD7hcd94I?Mk7W]V2g21kR4n6h55c;:L0F2h_57CUF@dMf_]A/:L<FhH09h0=D
H3Y5X5b4mi@35]=ME=gAh6^TW1@ANJ0Ck6S>i`AK2R?HZabNSRE>TL]BBS5EG1PY
X:MkI0_fR`2bN11^3TiOFV>oD2c0eo0</PdU^aXB`MN[bk5E_8;RLZ:T2?`Rn771
R/4MXZ^Nl;B4Tb8Z3kJ@GIBbbeB3DDild`Noc2U][R5;=98MNXk9@dmQ=TW?O89`
/8cch<Uj`YWI9`B[o=A;Q?VCZm0@c14lL4?9n@B764^L9>6I9cSDo3e0kN9Q_lT0
SSX@Xf90Y;^RMm4O^7UU@m5UK=dT2L9V6lZH8=QBF3P]A8keb1WhHA1^eaOOC82W
Nh[DPlC0L8KR48hZG9OU`VG78E]3/8`=PK7Ki6:QETALWEHa=CQoE;R>d2/P@Q1A
I0l^khP`o^8Af@8UF15SPR2`P6XRV9c01^6dT2E^^85g3LhMLcCNNEn?50WQoF4b
hNN4VnAkId/QEJ@PQok[HMcU^ifFPD?5P02B>LhN;]@JkCTQgdGf@ebGIc9NJ@dI
;PLoAnaXTc;JOgX:m8mBh9GF`PEnO<FU9m?;UlWYbdFC:MWRTC`3:oCa1Gk9^IDM
WcnlOGTegkbl`3_]bnof`nD[no:WoOiUbd2Pae_aQm07YXOa9[GMZ>T[Ld^mYg9A
OAT0iUbf_KHSabWK3Xi_Ye[_LTneARY/jDaYlo:j4hOk8nm:K`[N^hcIDcGIRSZV
R/Pk>nm2OkdG2W9hKY@3?cGcgBG]6X]OVo6H[mg`c/RL2]oDfK1_W>Z<0P=:biVO
:2eV=Z<2g6/KY[ij:Vln<[8a@FijWg_lMVK/b0la_LM1j9il=oMm@82OJ9`a]`I7
l@6WemOde4]>5BND<j6TMoR9V1b?VA1Sn8fCgB:3W89I8K3?LUTZdB^<llN1XSZS
[^UY0JE?;lIGVCdA[RfSBcEabJ6k40M7<@iTL5[8;>]k1Y5M2OEK@g6i><DkNA<1
gM9:MZgC2:N5Z;`ok4NHQSgAkfHQRnSNN_=a6WWfN?WC_Fod<81G<@?GTbMAE[Ql
N3O<1WGl[=nU3]najU67QfaJiX[NheVPD>WM`B[41KUHM2aX3Q0HebjDkJ<kD4j:
R3c@;@aYSm1N;4kL4g0jFo8V0UmHF^V^MA[Q]93Ieg21LgdgQU]2KQ>iV4N:WmIm
nWa>;`NE:;Aoan_9jfZOg@kJUCPk2^T<l?hGQ^XbLh`/0MD2gPCG>keOFIg8A60]
:RQS2_M^^P]9Lo@[@0JWQLc>1g@;@jfMFX5FbPTe4_M7Vkb9/3cEBWOYJIBC8R[_
mWI`;n=fd;]aXgin?CN9moAjj>1RAAoO`mMS?ZCgg@mb2LX_kW:dQn0RCS4DZchU
E:CE5FkQ40Qk2kGJ5D7@/4AnH`SNfbj<6@Kc`@Qk1[:g;8:13YEGbaQV;4kQC]i4
F5iG2ZadTnZ]S1BI_Momfm7K2LQgU4VLokloWUjm8_>Na;JKbhg__1dZIKIOd]bl
`WLE@jf=@0DocHk@A:6c`lB5>k_E]PTb_;TU_1kI1DiXBWYcUiFC8[=777ASEfZ^
XM9U//48`9Dh4`AQ<U5:/:Fh<]:CZ;CiM/aMe/4]FcB_oc^bX@E76BFGno3Uf0mG
ML63VP1Z6>;N^L:LdWDQ/2WDkHVhi[d[UM]kQ;cNKTZC]i2;JHM;YO7/@GMQ1S4j
C]PJMeaid2O8K5bA?AA3P<?=U8dCT1]iP^1ZE2_1E?79B4jbf^@Wk`HS=hcmg[RH
GR>Oa[@F;HinlVK@O>e=PABJ:96OIAbN?mhdTZlKeS`bO4SXnU25E@Z66TINW9ma
m4TW28JKb<4HQj4942`SVhlfECP9/UY>d>T^C0a`3g0miHC9ihdl@C0oE:d4fdhc
>Fg8K76Og0d/Bc68ecl=JCnl;bHI`^AU6`c0jaN0`IkW=17PSbQbKH2A48edU=2G
L41<HFXlXY7O<I0LX`IUX0P2^6D:1F1JI6cUPM43RUNcI?2bDhP>7MRD50I;kB7S
LNQ1[oef5mPW1=mM6A5UfDU3`Kk>>NmjCW:5mHTUJPD<OD;5M8d8KX]Y2Q8ahT6O
[d`49`dA4J5`2QL/h6RC^g9B18k8W9Q><KQT3Ccb54hN0f6NgRaiPS2MJ3DaJ:FW
DDj:37W@lf5I179D=Hf3jVU;/DN1kcL3>fBj=aXg8_H66FWe1DiMON_V`Y@?GoQK
2S]YKd[k9mb=;MUlVcmQUYG=X^?Uh<Va]2mP;Pk0Rc2PcYTlnbOcW>9hKJIRRdke
O68Xl/56kbEHGSoWVa;Sfle@?F0nl4@LR`o3YgP5LekPUK9M<26IUP[XKh1g5O/W
W01oCnTWW[oe3I<@/bWURIeHP5Do:EaJjC005Ikm4c]EGPNVIY=`j@WGONQ:Q?[h
lBa_MjB?K1oCIgU?ddV6Tbl3cIDL=>?_;=f5^QG<7==<4fFTfNi4`d@9JGhIelkU
W2S;JQiFB64g]Y:<OoPKbDF5cQn7PTZjm=d<QH9ZL`0dlG1^o47`SJcMHmZWgI?`
gQ3E7/He59mlB?`]I<b@a`ZemdP;lb=haRUP5oh@`]lLhM53Lf2G7e5MhE]9ai;i
l]jaVQA22Uj<MkhPiFoNZd;7Sd<U9Ag;`EOMj]IJo8L29>egVN_WIJiOoPF4R_3M
2VE^I7=dLVEQK@YUKVA_HVX:=B0`86mRJPXb<SLd2VE^I6mRJPXb830PKf9Z2S`l
82mDNG1U82m@HFMU82m@HG9UKW@P<b0`858P;e9ULfmeLV=ULb0f830PDR0_@fm^
M6E^M7<P=20`858P;deUI6UQ@Vmh85/`830P=C<a83<b<Ed:?Sh:IFiTKf9Z2SHP
<21_HVX:?3`P;e1bKf=CIG@PFb0_D4A682mDIGQd85dP;d=_K6mbDg1QHfDP?3`P
;d=c<B0g830PDR0n?R0_AVm^M20l?20_E5@a83PP<21B2Shn83hn2VE^I6mRJPXi
830PKf9Z2S`l82m<IFiWM6PP<C0P<21B82m>83<P;d5/M6EbKV5dIB0_A6EfJF=U
DTM282m6JFadIG8P;dI/HGAUA6ESKfAU83hn2W=dLVEQK@Yh0IfFMeACfAJ7ckdg
_M0B8R0Um1Yj2B3B>dPE1569BH1@0XJ49WI41DHD4BUFI5C00DN78V=550^3PV;G
2O8@D<K1DDA5iMf<J`W_[CGcgY[maeWOfNNgemUWkggG^P1@o884`WAH0H0dXEPD
k^_1G18CblCg0QP@0@iH0L3QIVH4AoQ40]Cl_CfIVJQ8a[?fkRj0I;_K;;m@9W?F
ognA8SM390H02TGE=San9QOU0YAC/lDI<_l4b_BE:C:6<C8FX@VR[2;Sa:m/mZOV
:k_9V9LVi:4JFLhI_3BNS;]@gYXUhJ><1:5LV2GPIj=l1fFmE4VJ0>Gg:=?Cn9a<
030DVEo<ibJQK8TbAA@IkXWb0P08U<@i_78>RoTiJ9h0N:IWi8X4RDURYQ7GV6WU
j<QVn_6cDoUR<B^D`dgQR7Q<coBd38h`5h2_KiI50BEIKIUXTNf]7>g]FMKVJ?Vo
fMlNOU?m?LQjneGa9^c?WT6<WUWOK>b/;kdF0?HTFY/M/kjEE@2dK@I0iN6/CnlP
0?850;CNW?<NQVaNT/CR32L;Rnc/K7<1Wf/^:nPgnin2KlZoQSWgVL_^neHkYQLo
PB=95C=UANFVYjI;A<c<30jGcfCmma3ohl0iJLg9`bbLWl0GlHGXEE7XU0V4RFRk
QCb1F90^I0Z4OmGQOaPf9`LIOYe[56QeG`1mQCU@^4T7b6lm04<S0bA^?gX2ON]K
434:b;jlJ:fA[g>?<W[nioXO2eb:K^5<@B9Ci_H<SfAb9J8/6J?OQ6c10Q:@1gBP
2SB1;S02;60=780cL0?N8024P4P@0iH3;TP2JD04/T4nf00:@C7H0GJ3JW00e85j
d0A>PSI`1U`4El0=L0/<P4M02XK1Bc01gX5Y28;`41FR@JZ@5Z@?VD;F41]J27U3
@E0h50?5@hV@4990nM0VZ1PZPjZQ@e0mm2=d6[X8GH?jX0O@83@6o@5mQ16H0]=Q
3MP0]X3I/3/L24O2bn14N1FL1aO0fn5:^1Hn3[O25n4Kl00/QEo2T`Q0b0P3dDIH
21_aA4:@F2@14B5[TB:T0ZU5VY0>Y1^iSDRALN@31XNQHIPH5/HIhhMIS>5REV7F
HTX`eIQSV5I<5nHfIQ0cPOV2YF;E/JIH9j`oMPTf4I^=;LAFH8mPFk2G/@?HHN`k
70k7`1WR771n^1QL<Vhe[PBg3mN<^h3[``gQ9_5h_2[N5>n23l5cl69l8Kh:Oaao
7]n?7lJo9i09FPA[PPlQUR0TK2AD41X8i`SmQ172=561Z4md8XH@NLALHRVaS]Q1
_4TL9TjC54V691MB92VI]85DBFXRGBHm9[dQTlTjI4Mb65U0GTn^99lPGbD?TSm@
U2PV54m:74E2fDhiB[U0ND1i@jEB3JQ^e5RZV;ZMFTnmA7e:OBm7Tc>GliOSbJfC
Zi5[UN^GNbE?U=NGMiMO;YlWGb5oB_jVo;P2DL50`E>1Xk1FXDKQ]<8mQDU5VZ:E
HXQRVV:9HX?R=LEA9KbBPI:g4TnY@>V`dRFU8AY2djEid[RdCK@jfVGJ<1e7=jCk
di?YaO@Oj;gd2FDUIE_U:>DLiA[U/lYB1/8`H?PcDQVUS9><^hb?lcCV^LoScm/f
[fUNok`YUOTZKRYlUB:EIYD1UHnZC5E_eACEWJY]ZToD<6XVJV5ZfF[keBj[SLnW
cgNNcieO=?oTo8OZ/;Z9N[SjJ_G3jSgZTaZJ6[hJ6AYE6YLdaSDIVVjJbI[UV^Ld
akAXFP^e15[UF^NeGS2EVNk<E6HU/h/iXJf^kJL]dCjTgJ/m[F>X/eQWXdjccQ=M
TRiK=d6gG;MCMd9?BbmH;en_DNnQ?U6O[InT_dNoFgo:`=0PfV2;@I_1Z:6:XKmQ
WV6ShF<SZY6[dBZSFZ<kaSQS]W6:lCkSFbJ`RIe9TTV=bDeCf=CNE62jckC?36_V
J2HdZcFkaj:`g5UI[4KFX3W3?<QlXgVKnB/;?H]HRidFgAIO;>d/Dbg[;1mI:ET5
F6fdj[3j`m[4VV]MHgg7QV[SHk?>Y]gV]JfY;Mmf_nem>iYM/=dF^djkcoH>mR;k
9_/a1cf7N8Nm3_OHM7HX^hAmeA7[j>6hc_6<h`LWNbNaddVWgieIcRW>3LjS2``G
l1OD;AQbdG7Q^1abTBiT;XaON72Qe5GKUN=Jjo[<CMN=igK4KLCMf3gIoKSk:`m;
3i57RlNDYi?W6/l;GXRG[eNAEjngT_MRkf[_Ychj?XTnSChC_WJnZgd_n67m0_ef
n]gceo3Wn]OkC`@h1:`9j0ZT14H4EPLn2c894PEe1<?10L6kPQl_dUlTG=@F0T;l
@gJ5?0Te35dEnW<H;R`d[2K/NKQEN7ihM`@]HTE4@lBkB8o8d/Q7RhdFBaIgA/U7
aDGEAde5NdFGAD^GF2aI/nA6S5Z<8:Hm5QlK5G/TMW:Ymm;MBhOSk>8:hnh^<ebF
/ncJL[GUZL_?[Y1O`EUa:QhK7agO4?n94l:YiDb^m5niMnD4ei>kQo^BilH[ihga
GOQUo944UhBbQ=54UlAMRF=9[TTEBN<2Cd6eh7FbGo:1i:VDT9BS:C>YdJW=JHBd
n;CC@REQR[0[GC<m9kd_`cBS<4>jbVWEkUDCXT3ATD`XLeUV^iR>oTceB8`TVbF3
F@^cJ[;NIdMUWlYAc17Vm>BJi6k;7LWcbO]n=FHeMgEW_WKnQ_c1=Ni[3Zf5eZiL
fkU>Meg1^^7e_^^?KB1]B=W`bdK;SFDKgfj:g]AAX56`_V1X/noVaT:i@U7Q_Bg>
F`i/aF`EK>gMI[>]J]^G8UkAmF;;hX[RCbGLT^_OFGeGnMg<mXC]_JGfYO]gh7H8
MmcMjK[cF9URFEkId:kPGJgUc?:Rl[NkEnbnEV5KLF0?JHmTSk@bZ;:mBZmZAmFW
jZCZPAZ?V^JmjW^gkIgJam_G_mm]Om<1S@?51chN51blOlSgD6^]@Fg5HMcQ[<??
jj;Z^[mWOemoA>e8lI7?AhE7YLO2SgGE>mCG=jPgU3K2SI;6/N=aafomh?E3Na>[
jE0cXkWh13PQ>O7RaoPOkih<?=UiRWfZjBOmWoJfd5Z:FZ7Fg=J9]Z@fJG]<NmoY
P=>M7LhM;CnKogcdS?JIV[?:Id_?TLhEW9/iWgMnlT;6QO6;RAN7>UMd?[Zdi=:M
[[2^g/^1UjmNlKUbZM^mnoaEUj]W[SUM>gfMOKg]Q_f=eQjkWYIOk7iYjKG_KKgY
L;?mU^>]S[h5ONOjGO/_g_JjONF>oidK0h/6n^h^_W_oG]`mjGgNoM47Z@mN?laj
>?eXoF?/hj8W2TlZWZXo[OgEn=MVZKgdk:3GH<ncR6N?Q[Q3;onEnJm?``G?ZLl[
A[A6jTN]Aln<nHcMN[7daO3;S9OChhFo:OjfmiGAZimnMo^mIf;9a?1[dN^I?d[N
Z;hin]KfKNMTj>CCMfW_YZN:gZ^n?oJ1oJ7kHoC7TNW/CoQ?UIn=?gMl2OcbN2I]
I^KOmhCcn`YUKVAcM79UHFd:IFiTKf9Z2S4`830PKf9Z2S8f<C8:IFiTKf9Z2SLP
<21_HVX:Fb0_BD=3@V5cIF@P>B0`858PG@YUKVA_HVX:<b0`86mRJPXl?20_E7U`
IB0_D65WIG<P;deUI6UQ@Vmh85/`830P=C<a83<b<EdP;d=_MFid834P;d]YI7<P
Fb0b830PDR1M83hn2VE^I6mRJPXa<B0`86mRJPXl?20_E7U`IB0_@f5dHFa_Ib0_
D65WIG<P<b0`858P?Sh:IFiTKf9Z2SPP<21_HVX:?3`P;eAiL6DP;dI_KW@P;e=e
HWAiL6DP;eAbMFEDNG1U82m2HG=UAVm^M20_B5QCB5Y=:dQUK7IUM6USHB0_AVm^
M4AULf=bJG1dKg8:<C8P<21B82m5KV=_I6U^Ib0_CF5SDVm]HFi5KV=_I6U^Ib0_
AVUbLgA3J65b83@i82m<HG=d@fQQLR0i>B0_EfUTM6Qc85/P=CDf2SDe=R0e=CHP
=CDf83De=R0e=CHP<20`830P<20`830P<20`830P<20f=SLP=SHg83Lb<R0g<S8P
=SHg83Ha<B0`830P<20`830:<20`830P=cLh83Hf=b0`830P<20`830P<20`830P
<20`830P<20`830P<20`83De=R0e=CHP=C0`85dP?Sh:IFiTKf9Z2S4b830PKf9Z
2S`l82mDNG1U82m6KfidA6EcHg9YL7A_LR0_AVm^M4iQKFDP;dQHDdQJCB]8IFaf
IGAYHf4P;dI/HFMc83<b82m6Kfid@T9_N21K;CTe<B0]=3Pa834d=3DP<C4b<Ud:
;dUdHFaYHd5^IfaU830P;d5cHfE^M20g=c0P;dAULf=UKW@P;C8c<20_@f5`B6EY
IfQd83La=b0_DgAUKEHP>CPP;eQ8IFUWJ7@:=C8c82mCM6E]B20h=B0_@GIWEfUT
M6PP=3@a82m=HGQGJFAdJ20a=C0`82m6KfidAVU/IC8P<C<P<21B83hn2VE^I6mR
JPXa<b0`86mRJPXl?20_C6E^IgAX834d830PDR0_C6E^IgAX<B0i=S8d82m6JFad
IG8P;dI/HGAUA6ESKfAU83hn2W=dLVEQK@Yh0KeJNgaDaODoLamkkcjBk2_IAoJI
cCkb8VA3@T8RFD9N?18SlI550PT@3144NDBQPP51821ETD11DEY5@31;@5e0:6;h
PKoj`5ZeDVZeP_EGVhnf1J]0MWmWkXH8ZOG37gjjmg=Vi/c<WCWc?FO>?>h^V;N`
6N:P7ERXWMPdM`I8_mA<039[f^bV^C5NN`GSYM?J5SQR?>l3H6O=V7_Gk1P_?P6P
/=heJe7onkYW0MBFU^JVjK5bX>oW]f16S2O3<4i]VKgPoQR_?H1aeJ`ido[;M@lP
kiWMM7moog0FNLLmCK>KHoECAHaCiljI_b36^hiQG3EgGW=oOE:?l[d317>el3S8
hFh@P04e?Pd0`QL::g1HB/_aEm?aj[HY2LDG@D>K1IQBoG<Yo_34c^GO=Uoa:QlC
_l<<nMGj=9JUAM80E0C;NiF?3IA8kf6P3D=MAQS689DPiB5UI8`b@S_I0HlR?H?4
`Tbb5QHQ[D7j1A8gT=Z5g46b]Y/C0hO88S2C/@4UIkmEKk8K5D[kKl=4MV2KoB?S
IhN92KGg:C5eah5lU88l@ij6jF0Wch6K;8HZl94]nm=VfA^aJ1O<AFY7HZF@T5gM
=[om:<T4=dO`7@oH>?:boBliFOKc>F66M=^?Nl<LAZoIT0/Tf8mI]mUoKKg;OQCY
QESAkSB/lK9mUgFFOH<]C;IdfangQPVnleP/FVS5Eenfcdk[]4o?TL[7MhJI5k[]
QEQnNd1Ycbm`f_>/incIg[18T<nbS[NWikaUClDG/IX36gD7=7J;MH=m11KI[>GN
4DR7bFjb5M;9eVkgF?/QC>9`mhm9:nP<Tio][o;U^<=TLB2ob]NIE^EeYhfg^m<Z
_5i<ggi:F27L:H`Bo4:6h1<lPU=85_BREUB;lJ9:E8RR:8C9W^hB^n``N@5:49HG
mX/bT@nC5c6C>dcfBYUkGa4iTA51e8NSWj3a4]27b@/7e3B5RIMUDTXF9W_gak;f
1^`LCG5BPIZQJ@``18J838b547TT;8>EBFdUaQ;]B4eQAMUo2QZUTZ]QaWon6HTe
e3V^[SjdfaX<nFTRJPeN[FjlV_R?lH:5F=ALVY4aK/:RoFecFfND=k_:6egUcDR=
XKE];LI@neB7Heo[G5[P2;6NaZWCFVSLe1bJjfX^2kFjbQckfZCg1QG?X<E][[9m
<:?le_Ym<`;=IMe]PKIbEe=IL?oDdWT=eoFeIZ2_NJDod5LYKF`NkF^Zm=jP_QYX
lECJE`?]Zh7f=CD`ENZ;3[ilIUgYo0EXWHkbVN<L8EmMJ<`]4n]3SZIPFIS/`<bb
QL0O0cEo17al>iRiK;03A3m2>T?Sb6gAcoVCX8k<S_jM;D:U7ZC4A4Z:hAPl0U^Q
2fB`4m<nV0bKh@gBRW=k4Qb03hP=QZ3_iB0<hn5=4Xfn2c?PFJbo08k3A]P7:WaW
=RARjG[RSRi6?X3YZK0RnT]8Q@9h68i08KJj7WZS^j;k/G@2g0Jkh@ElocO4aNcS
M=4GXnM0Q5^`cAEHlVidO;@;_F8VU48]iZj0XlC=WXVfP16:D;XWhFWH3Zo1glQb
LR3J4Vf;WXinRZIZ10_DhK>4722O/UgL`m4WXgn=AQ097jAS[hf`0Gj5kGOQL`aM
JcViVb`P6lQ69/0/I`i`:gU3Y0maB8=:O:YP3Za610i23o`3_R=O<DIFcBiPCdCc
X_l49Hc3DM:A=4<K?Z_`FHmS>TaTI2PICF[94_84fDSNHm:IfiQjiSkVO^Ic]XJM
a2iRgn?VLmgl>WjcC1Vi63dL?AUm7`aPQC]Q7Rc5dAf7dg01;Q4Ffk8@=bTRYF@b
?^eT:g>@K2L7VEYbS9aVMY<oTLo8En@b`c<Z9Y79H1H`6iPGV>?<fna<MR?k2oI?
k4E^9<o`foWc<[O`QlSDb9[8fm6Rj:OAKm75R^14cIA23Db19Qc]G1P63n8Xm^;C
QE[[PA?`Q_AlARc@2mlR2T2da4clY1ZO6W8cVD5VTVgT43i79EVnHE0AS9cA<0K6
`]@aDiWIC3_c?]?>9[?Yk5Qf8]^5cbWf0oHbNiWS>AfGb5EbHf0M=i_KP/l>KROG
cKg35o8SnA[nM[jMGl>_HjOako8Ob9K:e/^jIEo9_TJg>5jH8ja3kKb1=_/Jf_;g
?hjTX_An^0NVTC8b5CYA6m]94gBPMDdWZa6_^N2;=[1;fDYV:5[3DOPIF^/FF09[
f4V`?OYkMSMlR9Hb2i]/QnNiD[3bVe0kbf4XFU7o4dQ;Co=i?NiDEh[CPBkOTV`f
6@e9RGZMEZ>>DbTELU6@lAc;4<P/MeDd>T:NaQ3WLEEEIE7NeH@ICMMT=>9DMX@Z
[ZlCL]3gV[3X^YX1[3USD<e0[6IPX2IA>hZQ>2_CDNibQ=hZLcW2I>8]mIQnY<`E
M8AjYGBeU7iDB/MQf^W45acUaYHbAhPd>/Y35Fd]7NF=IEVIi600hE1TIE;74@0U
KCP4Xi^FX8>5dKA6NLS/:R/?VEbHaS;FGMhd?EAkBgeiFK;C6L@lc9Y@SgeTILh<
XIb`ESGM=Ge]>01C6fVZJE9mR6d:QYQ6fYHV8fA`UHD<RllK_fN_Y/[GGE<HH]`E
CLdM5J50heX4Uk:=U6]JQmbh>PLfbj`<eXO8bWhQZ8b]:2TE=kHV^1]K7B6iZmCE
d]7JR>32Q?Y^Ll0/>Ml@e=IgV`8VRLW:?6QLF^C4dAo<6YDeR/I5C^?BF?bGQf;i
_ce6Hn?BWTl`7SMQ00124G2=@CU3SVUB9bhD]X06c@G@<Jd0LL9OT>0`Ij8lXd<<
fPc[3_7^<DfQm[Z[H[BDaHA[K2g[UY_<dR9D6/CjSAgZ4JPY[:mf>CX^hV[Mj>[m
foDiCOdi<[Oj8]12Z^P1F`VAYZ_Y=[YH^W7D;DIG2mE_VjACi5g6lV/bT:O@D9U3
NUc0Jn^M8DL@<g0gVCT^3?;JnWf4[0n6BGAU6<Z/1g6?bTjIS<FIe=AVUV7ob6AU
HTJj4e=3<QdEf7<5]AE7Qj=Sc?@>AhFS1Hf9Ld/a5SAg1;<A`KYja0U^aAh3`NB1
I7<`>0;KbJK]h2]H_B>8;KCf]h2aU9GMQiF6I^9RbWYZjfnY3kFG9HL2ID7D0Y[_
/M[jd36dg60@JnD<B8XB;iUYk9OISc;WY6=iKZ`Eg;^dHa?1SPkJIUfmbaTje]6A
g47WFh`?4aRL4NS?20>]@R4?ToIJO1LSUc=IdX7CiDBaPQCCHFSBEbd:mn`oSW3n
P=chiW2D=Um2^>0W@[S`AQ0NLD<85`e8NQg2aBQc4DGhY_lN`R>_@kSTaa4>3<R=
@Xi2J@<B`ZDo4L:SK`CQ/Q]2^7a0d^/@[T2IbbW2UOlmQ:^^@gS<Sb<lMT1^578L
BS]F@WSlChA`mHdPG7=32=ll8>Ue2=NRc3MCQ6oikb4lhCZ4jghLhE/7i4HQKd=Y
KiD@__dW@_R>6d6hoXH@3Pi8NQg24e7V84GhcP640lTQ^=H?]`mb^o2C>nI9ed2>
>bEN2jGLO>Q12R3U80e3XWWEo>eP@mZ4ik69B<mQ^X_k3;YTQE0[YNO31:cGQXMa
NU:kNPNT`Y<9_C_:PEcYH<kRVHc7_1oj2KRgUh<2CbVZOb^>PoQoba^LTH2gD9[n
c7bH15oPFNK?C1^[HSMc5Vh?7lm?h5O865VmT2:/4fUk39hSP3^=idlFkk56anjF
a>``L4RR>Pa`6XWbV6K?HQYS0F<FHoUI>8A_0MbNL@QKhS4NVY>[LFZlB:GLn_2E
?o=7;Xd>LmFGlJh2Amn37Kk??hjSM>dCBIST1U@L9jPhXI<7AJELgMISk7Vo[a1:
BRjlUC=DUcNB3<oE^3@m[foa[3o6O]>Q2njhM0okSMAF0>FflDm12^`8e>Ac5M`M
o=gFNfb;KB_8:TI<5bNJkSHmH7[0lY:9QaBB`5WRCDk1H/;k:=jNT92RDnCYN8Mm
XC=5iGa@:4RJTa;_CEQV;dQ9[GAA>GkGNj5GOK7g79@DmaFGm6ZdQMUJ@b71F5]H
Z<406W:6SUhD/70VUE_SDF[SOB3G2ciRh^;D2QlA4c70VcVeV]2;P6G@T:l]8OW3
lo>6NE`YPTa`HM[YebKZ1ET2TF66<m4iM^E[aiH=Vm2ii62UQg^5;Ee8O=ml]ZSR
YCEC2jJKfOP[J@N9M^jLLGUeMboI/6kLb/=]Yb?Oo6[?h/[VlOTiMkC^UW39RGk4
VOT]J6lm0O/HEEeFLmZd[8EY2k=TWAhbC/a@63?dLNag>OZl>3aL^09jCIkj`KRh
W>BlE5k8bhTcMW[;=66l5Da@50bI`mSC7<]H;i=KjKl65L@6BWY;NQ6D2gfOZg_E
51n:S@A9O_I@T`OT_<OZC_78P?D1ahY34@j;bnh3/m_X8a`A4:i/36c>I<C<P`62
UI51`E8GdmBbIHPIJN2H_=`T@e:^?`JLC<RcTEco=C0>Xc3R2@hA]954?KQ8d_UG
EKj:EmK_NFVkeZfcN9:JAlgKg7bPg<=g1nhQRGoh^S:ch]h78ooheT/<YmJFg;_i
oROJ27VJIA`5Smjmh?kBaLo<?OGj`ADCLZgfONe_AB88:eXggR]cfObCV8Z3BH4D
>J<@h`S37=G:I08S8k`Ph[UOD30;UOaG[4[Pf30a_4@jhl@mRS2YgllWE<I;25jl
D=b7EUF2DK6VD48=PB]L=BB3Fj8nTI0cU6STA>?<8kVJg4BGQWT^TTONkU_7?;[i
_OO`bV1=ggdAWT`>/N^_C7TZlT/Z6h7Bj5W>P_M73SPLb:SB[[HcQJX:gAfj^gCL
254E9h1:TA0O_e2[dfWS4aaJW@0jPl:@Qh:U1<aa3lK7FkDS4SP^cg7B6ZLA2/ac
X<2AD^V<JOaRK`lZ^kNT3kEmk/9ECM=YP3:Sb11C?N[NR??1Ik@C>N=QKGQiPeNo
3]j2Ld9^a83H>Ao8TS4@CK6i@KF];ZKZY[Y^d5fWIjl>9`B;TbCGcbGZ6FM:Z[M?
^bA`jc=KGVU_F9Wmi6cVRkjWKo9WeLhl@KBG8keMTGnZbN`]AKHg7nQl]RXPImTG
8o<l>VOTmMm4o_O4Vi8>Zj=oh5cl=TP6;n`:5=iW9PKA;GY=mJJ7HAEI;ALZAHGC
jlb;SmNc9hFlI=jKQg<USEUV:m3<<BRHHTEZSR6]dRL1deOh`;P9mbo>=Z:Kj9l?
M49@P:AY<<c]/CPBTT36Na`9=Qoa9:Kj`:;359dCQ6?]JZN?^9>l?[1Z<J1c@_8E
93H1j0aHAQ[`/d9BX/_SAJo1O0n7:`Ddj^5JYkIoFRCZTg;IbR?MJ]NX5I^j5B<W
gmijP:PRGkhA>C]Z2AVok96U>aId?Od8_nfk5KL=WASi_lRE>k=lWimk?O8NbL6[
8>DQ<_gB7gnmo9jCFkJ^YWN<;=Q`=K`9e`E6FXo>16Z[B3eY8NaZMQ>gFK5;4IJ7
5C:OPX0PTa56U</aD830TgF4iAajQL:]aC`mck]aQQ2UTVOU2Tk64bE3F61/PQPV
`H0L[eYTLPG;8kLcX8f;<aS<o3JbCF5BaFeg[Y^<=lVVVP_6j[hnDdeiLmWW5FE6
:34DUaAGmdWCYh@jWIQ7cYJ/LAbN2;USbB6^9kQZR17=TfJ`V<7f13?jjjiB5aL;
B3SE6Q1NXRBjG>9RWJb;/>_oe;_bDbKac<Jn`dnobCc:C:@CSYefJC@9AjZTEG8C
h/9QBX5gYciH7RRH63MAdlZda[EZ5S?g>HDaLEDJaR[J4cRk3S7dRSH3XkAiABhW
NFI2S/^L;Tmdni9<JNUQ<VFo/fd63[7V0Qe?SOZKJ/V@nRC7f_Nm@mDJcKaXL//l
PY7;8;aIc41WBDf5fTL3TK`QfXMCLdfBMC[X_AIjAIaE=4hSC<oBRW/FURj??4Gf
_U:Clo?aBb8;GfO^8lc/`<eYeOLFC0^^S7cL]h6]M@gonJ=nBjB`Kf;[j2W?S;3g
GNIeFnjlKfd`fi^AgkQ[oO`mJ1DCXfOhNoWcH4E;fALXB^HgTDjN]N</GdiFlF]d
O9g8?VcEJ19U8jb/JTBRg<KHK2HfQbUBifS<3WV>bFAgK7NfaP2Xk^dO?/hPM8ja
]DGM:dfT4F0a^7FNN7NbAiTTmd>LG^dWFTf2F[0Pa`?[9hCQF8EAiHL4;@JRFNK7
9@H3^Y3PM:8C:QKBS6Fh[8S4h1Y2Y5VTYL_9l5aLPYd>[`MWEKkCaMW8<<eaihW^
Sb8GookEfOTgfHjK7nn:O1R55lo_>D@ZOOcib9W3jgM4gXVLR4@R_mhEO>b;Yhi/
OH_/8NFWobciV^O@CZJQWLCQoOIM0O/ZCJNFlH]:F`83=X<Xi^S<iSQg_<UTo/3I
]THbP^Xn2@<XjB_YT`K^8DTJMj979_029k028o0bQE[4dBIQ8=LZoDC@hhfY]6ZV
dg6ijDSX7T?=X3E89Z3A2`bZoWCcZ0ESRl`97odml_@YYXiT?knaOV_ThKj^gHWN
>L6eMIE4@hILg/c[?S`NNON_Ab;MdQRjL<g[aC7@oFQ=85F`LIbB]N7W9KUXDbQ5
5J=B<B2KbAC9cO6/j0ICG7bH:?Lk=ehMT6CD5lkQa:=JYC^YH^XSLGSD^f_jRGAa
fELf/1UGgVLO^7bL/O=73TA:MdOR^k1[o16l5`I^=c9b:0`HZACbORUTMa>cD^YI
X@bC>k3W/oe@BSgCMOKO>WAe/IN__<VlfiMmD^ZXZfljmGNedOOi;m2N4g1e/417
87<EK_9?T]NIDn8K2]UX<G540Y/l@Y1K68]5ZLeQcCISS]9T]OenT0T?6;2T@SnH
hcc4;GOcWZAhXaodX?DC/hPY]@aC1UFRWnPH34b:I3mX>0`TVjD1oN6j28HTSEYP
nXeCj`A]WQZXiNZeCYKKN_Saig/R6b=kSnmmhRQn5TWn<_;g;lm5?_TGBHcWcemj
?G8jl/ZI:7cbNc:FY?n>Z2omTRbjR9lXRR<W8nmLR>cS9n=LY_QnRoPZD;jV@=i<
eDc]8]ER;ENU[mNgj1O[>D6dJMAZ1HU?X=YGR8a<Zn;TNWd>Idi:T:?R4i=n@?5m
6]`baoB^AUQ@o@@gc@djJKlV@`]ePNBfW;Rijf8fmWcm`LLAodVfoOkBnI45I=g3
co=7oWQZCkA_0gM`Q3g2cW^DjVT2kWGXUhL4?6DE`al31NU3RD:]C5II_;UEjYWb
E[E@:6YELSKI;jC:[FZE]BR36I9Fm4XADnA?Mf_E0RmJ_2T6BiQd15`6Zeg`FXLX
6F^N/UPX;[KXQKCdWJWVTLUYU[49gP;CCB=O9I_`Pl]1dPTadd8OCNOY^KjN0EGS
mTQKB0OKP9HnY7M8;efF=8KH?/2G?c`a1HS9CO8CW62d9C/QbJ5g4VL:36NLH;HJ
W2CAR@7EO?oJgkoiCLEmko3lVdPlTHh8RMNM7dKR?QQM^`IGOSmf4HoNc>_ad/RC
=bao^8k4cj^I4^ad]_QWClfY8`M69ZXNF_a8TE>aTooG[hjd;CBhECI=NZJW8Ce9
?_c]1cHN>KBYhif9VF=f?9IXTLG7FK;_8[?4C6?FY;[ajGGo/kFZJW?O9T/:bjiD
bDYMPJ[FUeI_O5I7c]6mLE_dHlk=7lNcY`gV1XK/49jgO6QQDl@46l<36:blX57H
[4ZUgR^J7NHQjR4T3CCXoULiScALGOo>WN_gO[gDoF_`S2E=8:<fBJI8T^TmA:_0
854`N8Q>K_?4_1kM=nYb=A@:[DK?B0PT^U87=TEhL6S[:WZflMAggiaIO:^oL0Lc
hk777_WI@DoULOihgiOE]dAj8aLRTE2AZg[=TRn>k_[hiGLgCMhWnCklf/JNiV[0
S?kPnD3flbJbfKQCg6eTahZJ[GZFeL^/IR7>ZULV2lW91[EGBo2HY35K5Ej3bH9o
@A3f>nL]jKLH75UaMFmQ8OEmPeNgHF0BgJY4Q@ORMFXL9EgGC<SQ^^JDeSEUDY`7
ecD<i4JIQji[cQmHea08g2/VaEHe@DKgPfPE^M@L6?@G^@;c`FN6;_FlYG_63Ugm
n=b7C5ff[`oomQ;Ao/k2eH@nW?K@c]W?K3nki[kgCi3Lco5Ch@PNmB[mX/gh[OB7
OU[<e><^:0VoPQ[1Q5n=gN31WKD?_lCjlKJS3<ZQ@WZAh5MQ8ZETN4<1EOEeEA>[
<jZJIkDe;iPi[@U;HZFdBRgB92Cj7HonEfLMdY=8Ni1NAJ8knK=8Od>jPRnZT2a8
VDS5B>>A9TGkOeP71]84clCGloi1O>hP7/mlekfO=hS?7lB?6/BG3^973n;;1_7U
PgP9_F_T_gU@>LGZf_5A9:oUY`kRYe7no`6Nkom=2VE^I7=dLVEQK@YUKVA_HVX:
<C@P<21_HVX:=S4i=PYUKVA_HVX:<CDP<21_HVX::6eQHdmC85IULW=YKfhP<C0^
<C@^=R1L:49eJFaT834hAcPgG2TPDGEQLWAj8514AT=_KWAUN7@Y2VE^I6mRJPXa
=R0`86mRJPXXA3Xb<34i<3Pb=S8`<3Pb=5X`<2L`<2LY2VE^I6mRJPXa830PKf9Z
2S`l82m@LVmTMF=ULR0a=B0`858P;d=bIF5dJFm^A65dIB0a=R0`858P;de_I4AQ
M6DP<CHP<21B83hn2VE^I6mRJPYhLVEV2S0P<CL:<30`<30`<30`<20f=CDc=B1V
80X`<30`<34b=3Lc830`<30`86hP2S0`<30`<38c>C0P<30`<30PKR0:<30`<30`
=C<f<B0`<30`<21^80X`<30`<30`<38b830`<30`86hP2S0`<30`<38c=c0P<30`
<30PKR0:<30`<30`<S@i=20`<30`<21^80X`<30`<30e<c8f830`<30`86hP2S0`
<30`<3Dd>C@P<30`<30PKR0:<30`<30`<SDi<B0`<30`<21^80X`<30`<30e<c0e
830`<30`86hP2S0`<30`<3Dd=3@P<30`<30PKR0:<30`<30`=CP`<20`<30`<21^
80X`<30`<30f<3D`830`<30`86hP2S0`<30`<C8c<cHP<30`<30PKR0:<30`<30a
<S<e=b0`<30`<21^80X`<30`<34b=3<a830`<30`86hP2WAbHFU/IG8:?3`P;e=Y
NVDP<CLP;e9_Kg@P<C4P<21B82m9KVI_834P<21B82m9A21K83`a=VDi=c4a=3D`
HSMT=S@i=STfHC0a=CP`<6=SHCLhISh:?34fICTg<C4d=C1R=f@f=3Tf>CIQ<34e
>30`Hf=Q=cQV?R1M83hn2W=dHG9dN79UIPXa<SDd>0XU9DE?APX\>"], "Graphics",
  ImageSize->{281.4296875, 170.1298110875706},
  ImageMargins->0,ExpressionUUID->"f5800d26-3d6b-4cc6-addd-11b5fb71f0ff"]
}], "Graphics",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.775838924268386*^9, 3.7758389379704847`*^9}},
 ImageSize->{289.19140625, 200.80931355337077`},
 ImageMargins->0,ExpressionUUID->"ff9fe624-c496-4de3-b8cc-43b55176f688"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "K1", ",", "K2", ",", "K3", ",", "K4", ",", "K5", ",", "K6", ",", "e", ",",
     "f", ",", "g", ",", "h", ",", "j", ",", "k"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"s1", ",", "s2", ",", "s3", ",", "s4", ",", "s5", ",", "s6"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"r1", ",", "r2", ",", "r3", ",", "r4", ",", "r5", ",", "r6"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"a1", ",", "a2", ",", "b1", ",", "b2", ",", "c1", ",", "c2"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    RowBox[{"K2", "/", "K1"}], "\[Equal]", 
    RowBox[{"a2", "/", "a1"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq3", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"K1", "+", "K2"}], ")"}], "/", "K3"}], "\[Equal]", 
    RowBox[{"e", "/", "f"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq4", "=", 
   RowBox[{
    RowBox[{"K4", "/", "K3"}], "\[Equal]", 
    RowBox[{"b2", "/", "b1"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq5", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"K3", "+", "K4"}], ")"}], "/", "K5"}], "\[Equal]", 
    RowBox[{"g", "/", "h"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq6", "=", 
   RowBox[{
    RowBox[{"K6", "/", "K5"}], "\[Equal]", 
    RowBox[{"c2", "/", "c1"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r1", "=", 
   RowBox[{"K1", "/", "s1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r2", "=", 
   RowBox[{"K2", "/", "s2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r3", "=", 
   RowBox[{"K3", "/", "s3"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r4", "=", 
   RowBox[{"K4", "/", "s4"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r5", "=", 
   RowBox[{"K5", "/", "s5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r6", "=", 
   RowBox[{"K6", "/", "s6"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"S", "=", 
  RowBox[{
   RowBox[{"c2", " ", "a2", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1", "/", "r1"}], "-", 
      RowBox[{"1", "/", "r2"}]}], ")"}]}], "+", 
   RowBox[{"c1", " ", "a2", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1", "/", "r3"}], "-", 
      RowBox[{"1", "/", "r4"}]}], ")"}]}], "+", 
   RowBox[{"c1", " ", "a1", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1", "/", "r5"}], "-", 
      RowBox[{"1", "/", "r6"}]}], ")"}]}]}]}]}], "Input",
 CellChangeTimes->{{3.77564989692628*^9, 3.77564989997371*^9}, {
  3.77564996859017*^9, 3.7756500417899446`*^9}, {3.775650074766418*^9, 
  3.775650095781858*^9}, {3.775650256695456*^9, 3.775650262462459*^9}, {
  3.775838963100164*^9, 3.775838976906809*^9}, {3.775839031564909*^9, 
  3.775839053354738*^9}, {3.7758391373324947`*^9, 3.775839150124207*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"56158de8-7cc6-4555-be84-82890bebcee5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a2", " ", "c2", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["s1", "K1"], "-", 
     FractionBox["s2", "K2"]}], ")"}]}], "+", 
  RowBox[{"a2", " ", "c1", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["s3", "K3"], "-", 
     FractionBox["s4", "K4"]}], ")"}]}], "+", 
  RowBox[{"a1", " ", "c1", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["s5", "K5"], "-", 
     FractionBox["s6", "K6"]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.775839151197383*^9, 3.7758393161889133`*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"dba26cf9-21e8-42ed-a7a2-111889aa7c11"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"fixs", "=", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s1", "->", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"e", "+", "a1", "+", "j"}], ")"}]}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"s2", "->", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"g", "+", "a2", "+", "j"}], ")"}]}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"s3", "->", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"g", "+", "b1", "+", "f"}], ")"}]}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"s4", "->", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"k", "+", "b2", "+", "f"}], ")"}]}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"s5", "->", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"c1", "+", "h", "+", "k"}], ")"}]}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"s6", "->", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"c2", "+", "h", "+", "e"}], ")"}]}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ceva", "=", 
   RowBox[{
    RowBox[{"a1", " ", "b1", " ", "c1"}], "\[Rule]", 
    RowBox[{"a2", " ", "b2", " ", "c2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fixegk", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"e", "\[Rule]", 
      RowBox[{"f", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"c2", "/", "c1"}], "+", 
         RowBox[{"a1", "/", "a2"}]}], ")"}]}]}], ",", 
     RowBox[{"g", "\[Rule]", 
      RowBox[{"h", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b1", "/", "b2"}], "+", 
         RowBox[{"a2", "/", "a1"}]}], ")"}]}]}], ",", 
     RowBox[{"k", "\[Rule]", 
      RowBox[{"j", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"c1", "/", "c2"}], "+", 
         RowBox[{"b2", "/", "b1"}]}], ")"}]}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"fixK", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"eq2", ",", "eq3", ",", "eq4", ",", "eq5", ",", "eq6"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"K2", ",", "K3", ",", "K4", ",", "K5", ",", "K6"}], "}"}]}], 
    "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.7756502015023603`*^9, 3.7756502496531897`*^9}, {
   3.775651502329653*^9, 3.7756515648659773`*^9}, {3.775651809729458*^9, 
   3.7756518479383507`*^9}, 3.775652123475103*^9, 3.775652246363236*^9, {
   3.775652456043412*^9, 3.775652462697936*^9}, {3.7756537502138357`*^9, 
   3.775653756029043*^9}, 3.775653805806649*^9, 3.7756551371996737`*^9, 
   3.775655275784131*^9, {3.77583907196419*^9, 3.77583908020277*^9}, {
   3.775839329487731*^9, 3.775839341164874*^9}, {3.775839436493544*^9, 
   3.775839450980508*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"a753c1a6-f6d8-448b-a30d-932ab96123c7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"K2", "\[Rule]", 
    FractionBox[
     RowBox[{"a2", " ", "K1"}], "a1"]}], ",", 
   RowBox[{"K3", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a1", "+", "a2"}], ")"}], " ", "f", " ", "K1"}], 
     RowBox[{"a1", " ", "e"}]]}], ",", 
   RowBox[{"K4", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a1", "+", "a2"}], ")"}], " ", "b2", " ", "f", " ", "K1"}], 
     RowBox[{"a1", " ", "b1", " ", "e"}]]}], ",", 
   RowBox[{"K5", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a1", "+", "a2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b1", "+", "b2"}], ")"}], " ", "f", " ", "h", " ", "K1"}], 
     RowBox[{"a1", " ", "b1", " ", "e", " ", "g"}]]}], ",", 
   RowBox[{"K6", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a1", "+", "a2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b1", "+", "b2"}], ")"}], " ", "c2", " ", "f", " ", "h", " ", 
      "K1"}], 
     RowBox[{"a1", " ", "b1", " ", "c1", " ", "e", " ", "g"}]]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.77583934208677*^9, 3.775839358664572*^9}, 
   3.775839452537828*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"c9057251-f0db-40e1-8482-225ec2a3c5bc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S2", "=", 
  RowBox[{"S", "/.", "fixs"}]}]], "Input",
 CellChangeTimes->{{3.775654514798554*^9, 3.775654525229879*^9}, 
   3.77565555634424*^9, 3.775839176923902*^9, {3.775839373604535*^9, 
   3.7758393741557913`*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"0c413bdf-fc3a-4e56-bfec-aadeaba0c175"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a2", " ", "c2", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"a1", "+", "e", "+", "j"}], 
      RowBox[{"2", " ", "K1"}]], "-", 
     FractionBox[
      RowBox[{"a2", "+", "g", "+", "j"}], 
      RowBox[{"2", " ", "K2"}]]}], ")"}]}], "+", 
  RowBox[{"a2", " ", "c1", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"b1", "+", "f", "+", "g"}], 
      RowBox[{"2", " ", "K3"}]], "-", 
     FractionBox[
      RowBox[{"b2", "+", "f", "+", "k"}], 
      RowBox[{"2", " ", "K4"}]]}], ")"}]}], "+", 
  RowBox[{"a1", " ", "c1", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"c1", "+", "h", "+", "k"}], 
      RowBox[{"2", " ", "K5"}]], "-", 
     FractionBox[
      RowBox[{"c2", "+", "e", "+", "h"}], 
      RowBox[{"2", " ", "K6"}]]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.775655168056424*^9, 3.775655289472907*^9, 
  3.775655351432973*^9, 3.77565555810712*^9, 3.77566301486517*^9, 
  3.775839099313059*^9, 3.775839178695229*^9, 3.775839376168582*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"07ae774b-ae92-4f93-baa2-b261ed050f8d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S3", "=", 
  RowBox[{
   RowBox[{"S2", "/.", "fixK"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.775654587974844*^9, 3.775654597142178*^9}, {
  3.7756546870947037`*^9, 3.775654689765272*^9}, {3.775655562895875*^9, 
  3.775655567438422*^9}, {3.775839380108891*^9, 3.775839383419759*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"6053eca3-0bdd-4cb5-86b3-5bce5a172942"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a2", "2"]}], " ", "b2", " ", 
       RowBox[{"(", 
        RowBox[{"b1", "+", "b2"}], ")"}], " ", 
       SuperscriptBox["c2", "2"], " ", "f", " ", "h", " ", 
       RowBox[{"(", 
        RowBox[{"e", "+", "j"}], ")"}]}], "+", 
      RowBox[{"a1", " ", "a2", " ", 
       RowBox[{"(", 
        RowBox[{"b1", "+", "b2"}], ")"}], " ", "c2", " ", "h", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "b2"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"c2", " ", "f", " ", 
             RowBox[{"(", 
              RowBox[{"e", "-", "g"}], ")"}]}], "+", 
            RowBox[{"c1", " ", "e", " ", 
             RowBox[{"(", 
              RowBox[{"f", "+", "g"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"b1", " ", "c1", " ", "e", " ", 
          RowBox[{"(", 
           RowBox[{"f", "+", "k"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a1", "2"], " ", "b2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b2", " ", 
          SuperscriptBox["c2", "2"], " ", "f", " ", "h", " ", 
          RowBox[{"(", 
           RowBox[{"g", "+", "j"}], ")"}]}], "+", 
         RowBox[{"b1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c1", "2"], " ", "e", " ", "g", " ", 
             RowBox[{"(", 
              RowBox[{"e", "+", "h"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["c2", "2"], " ", "f", " ", "h", " ", 
             RowBox[{"(", 
              RowBox[{"g", "+", "j"}], ")"}]}], "-", 
            RowBox[{"c1", " ", "c2", " ", "e", " ", "g", " ", 
             RowBox[{"(", 
              RowBox[{"h", "+", "k"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}],
     "/", 
    RowBox[{"(", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"a1", "+", "a2"}], ")"}], " ", "b2", " ", 
      RowBox[{"(", 
       RowBox[{"b1", "+", "b2"}], ")"}], " ", "c2", " ", "f", " ", "h", " ", 
      "K1"}], ")"}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.775657079718124*^9, 3.775657100711554*^9}, 
   3.775658953562372*^9, 3.7756630590139523`*^9, 3.775839198057486*^9, 
   3.775839386822795*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"c9783396-5c35-45b3-a5ac-0e997a451aa0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"num", "=", 
  RowBox[{"Numerator", "[", "S3", "]"}]}]], "Input",
 CellChangeTimes->{{3.775655573571948*^9, 3.775655589558757*^9}, 
   3.775839206820142*^9, 3.7758393912527122`*^9},
 CellLabel->"In[28]:=",ExpressionUUID->"04c6ebdf-e14e-42a8-a7d9-ef6ab6c9c017"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["a2", "2"], " ", "b2", " ", 
   RowBox[{"(", 
    RowBox[{"b1", "+", "b2"}], ")"}], " ", 
   SuperscriptBox["c2", "2"], " ", "f", " ", "h", " ", 
   RowBox[{"(", 
    RowBox[{"e", "+", "j"}], ")"}]}], "-", 
  RowBox[{"a1", " ", "a2", " ", 
   RowBox[{"(", 
    RowBox[{"b1", "+", "b2"}], ")"}], " ", "c2", " ", "h", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "b2"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c2", " ", "f", " ", 
         RowBox[{"(", 
          RowBox[{"e", "-", "g"}], ")"}]}], "+", 
        RowBox[{"c1", " ", "e", " ", 
         RowBox[{"(", 
          RowBox[{"f", "+", "g"}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{"b1", " ", "c1", " ", "e", " ", 
      RowBox[{"(", 
       RowBox[{"f", "+", "k"}], ")"}]}]}], ")"}]}], "-", 
  RowBox[{
   SuperscriptBox["a1", "2"], " ", "b2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"b2", " ", 
      SuperscriptBox["c2", "2"], " ", "f", " ", "h", " ", 
      RowBox[{"(", 
       RowBox[{"g", "+", "j"}], ")"}]}], "+", 
     RowBox[{"b1", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["c1", "2"], " ", "e", " ", "g", " ", 
         RowBox[{"(", 
          RowBox[{"e", "+", "h"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c2", "2"], " ", "f", " ", "h", " ", 
         RowBox[{"(", 
          RowBox[{"g", "+", "j"}], ")"}]}], "-", 
        RowBox[{"c1", " ", "c2", " ", "e", " ", "g", " ", 
         RowBox[{"(", 
          RowBox[{"h", "+", "k"}], ")"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",\

 CellChangeTimes->{3.775655590732129*^9, 3.775663066121962*^9, 
  3.775839218772707*^9, 3.7758394012439947`*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"8573df9d-1b2c-4c71-a888-b4f68567f4f1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"num2", "=", 
  RowBox[{
   RowBox[{"num", "/.", "fixegk"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.775655596499919*^9, 3.775655617950467*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"99f74164-647c-45f8-9cd7-81523b0f00c3"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["a2", "2"], " ", "c1"}]], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "a1"}], " ", "b1", " ", "c1"}], "+", 
     RowBox[{"a2", " ", "b2", " ", "c2"}]}], ")"}], " ", "f", " ", "h", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a1", "3"], " ", "b1", " ", 
      SuperscriptBox["c1", "2"], " ", "f"}], "+", 
     RowBox[{
      SuperscriptBox["a2", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"b1", "+", "b2"}], ")"}], " ", "c2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c2", " ", "f"}], "+", 
        RowBox[{"c1", " ", "j"}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["a1", "2"], " ", "a2", " ", "c1", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b2", " ", "c1", " ", "f"}], "+", 
        RowBox[{"b2", " ", "c2", " ", 
         RowBox[{"(", 
          RowBox[{"f", "-", "j"}], ")"}]}], "+", 
        RowBox[{"b1", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "c2", " ", "f"}], "+", 
           RowBox[{"c1", " ", "h"}], "-", 
           RowBox[{"c2", " ", "h"}], "-", 
           RowBox[{"c1", " ", "j"}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{"a1", " ", 
      SuperscriptBox["a2", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c2", "2"], " ", "f"}], "+", 
           RowBox[{"c1", " ", "c2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "f"}], "-", "h"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c1", "2"], " ", "h"}]}], ")"}]}], "+", 
        RowBox[{"b1", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c2", "2"], " ", "f"}], "+", 
           RowBox[{"c1", " ", "c2", " ", 
            RowBox[{"(", 
             RowBox[{"f", "-", "j"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c1", "2"], " ", "j"}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{{3.775655610784649*^9, 3.7756556189695253`*^9}, 
   3.7756630748783283`*^9, 3.775839229454506*^9, 3.775839419407935*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"0dc8b503-d45e-4f9b-9813-cb05dad735e5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"num2", "/.", "Ceva"}]], "Input",
 CellChangeTimes->{{3.7756556329195957`*^9, 3.775655644191934*^9}, {
  3.775839237260315*^9, 3.775839247851968*^9}, {3.775839460788809*^9, 
  3.7758394636761103`*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"41222824-b357-437d-9d0d-ede880aa7eb6"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.775655640264629*^9, 3.77565564485163*^9}, 
   3.775839250950344*^9, 3.7758394646986628`*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"c94b50ad-b2db-4aa1-8a20-e18b676f6dd0"]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{Automatic, 310}, {64, Automatic}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1300, 22, 242, "Text",ExpressionUUID->"ec84d7e9-954d-4d3f-9bf1-2adbad1f2e59"],
Cell[1861, 44, 161, 3, 35, "Text",ExpressionUUID->"a44375db-8dd6-4fe5-877a-e7a40192c170"],
Cell[CellGroupData[{
Cell[2047, 51, 453, 10, 30, "Input",ExpressionUUID->"da321093-4ee0-4a42-b9d8-1cfdcbd5d2cb"],
Cell[2503, 63, 34572, 537, 212, "Graphics",ExpressionUUID->"ff9fe624-c496-4de3-b8cc-43b55176f688"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37112, 605, 3052, 88, 346, "Input",ExpressionUUID->"56158de8-7cc6-4555-be84-82890bebcee5"],
Cell[40167, 695, 613, 18, 51, "Output",ExpressionUUID->"dba26cf9-21e8-42ed-a7a2-111889aa7c11"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40817, 718, 3189, 94, 220, "Input",ExpressionUUID->"a753c1a6-f6d8-448b-a30d-932ab96123c7"],
Cell[44009, 814, 1306, 38, 94, "Output",ExpressionUUID->"c9057251-f0db-40e1-8482-225ec2a3c5bc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45352, 857, 321, 6, 30, "Input",ExpressionUUID->"0c413bdf-fc3a-4e56-bfec-aadeaba0c175"],
Cell[45676, 865, 1131, 32, 52, "Output",ExpressionUUID->"07ae774b-ae92-4f93-baa2-b261ed050f8d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46844, 902, 401, 7, 30, "Input",ExpressionUUID->"6053eca3-0bdd-4cb5-86b3-5bce5a172942"],
Cell[47248, 911, 2397, 65, 104, "Output",ExpressionUUID->"c9783396-5c35-45b3-a5ac-0e997a451aa0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49682, 981, 283, 5, 30, "Input",ExpressionUUID->"04c6ebdf-e14e-42a8-a7d9-ef6ab6c9c017"],
Cell[49968, 988, 1803, 52, 79, "Output",ExpressionUUID->"8573df9d-1b2c-4c71-a888-b4f68567f4f1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51808, 1045, 260, 5, 30, "Input",ExpressionUUID->"99f74164-647c-45f8-9cd7-81523b0f00c3"],
Cell[52071, 1052, 2342, 67, 98, "Output",ExpressionUUID->"0dc8b503-d45e-4f9b-9813-cb05dad735e5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54450, 1124, 303, 5, 30, "Input",ExpressionUUID->"41222824-b357-437d-9d0d-ede880aa7eb6"],
Cell[54756, 1131, 222, 3, 34, "Output",ExpressionUUID->"c94b50ad-b2db-4aa1-8a20-e18b676f6dd0"]
}, Open  ]]
}
]
*)

